<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redis;
use App\Models\InverOrden;
class ChartController extends Controller
{

    public function __construct (){
     //   $this->mecubroService = new MecubroService;
    }



    public function getChartData($id, $periodo)
    {
        $data = Redis::get('datos_' . $id . '_' .  $periodo);
        $ordenes = Redis::get($id . '_ordenes');

        // Decodificar el JSON a un array asociativo
        $dataArray = json_decode($data, true);
        unset($dataArray['solo_close']);
        $ordenesArray = json_decode($ordenes, true);
        $operacionesTerminadas = InverOrden::whereIn('estado', [0, 4])
            ->orderBy('id_orden', 'desc')
            ->limit(200)
            ->get()
            ->toArray();
        // Añadir la nueva clave "ordenes" al array
       $resultado=[
        'velas' => $dataArray,
        'ordenes' => $ordenesArray['ordenes'],
        'finalizadas' =>  $operacionesTerminadas
       ];

        // Codificar el array nuevamente a JSON
        return json_encode($resultado);
    }


    public function getChartData3($id, $periodo)
    {
        $data = Redis::get('datos_' . $id . '_' .  $periodo);
        $ordenes = Redis::get($id . '_ordenes');

        // Decodificar el JSON a un array asociativo
        $dataArray = json_decode($data, true);
        $ordenesArray = json_decode($ordenes, true);

        // Añadir la nueva clave "ordenes" al array
        $dataArray['ordenes'] = $ordenesArray;

        // Codificar el array nuevamente a JSON
        return json_encode($dataArray);
    }


    public function getChartDataBackup($id, $periodo)
    {
        $data = Redis::get('datos_' . $id . '_' .  $periodo);
        return response()->json(json_decode($data));
    }


    public function getEstrategias()
    {
        $data = Redis::get('estrategias');
        return response()->json(json_decode($data));
    }
    public function getCoinEstrategia($id)
    {
        $data = Redis::get($id . '_estrategias');
        return response()->json(json_decode($data));
    }
}
