<?php

namespace App\Http\Livewire\Components;

use Livewire\Component;
use App\Services\MecubroService;

class PageFilters extends Component
{
    protected $listeners = ['page-enable' => 'pageEnable'];

    public $meta;
    public $filters;
    public $botones;
    public $links;
    public $filtroFecha;

    public $txtsearch;
    public $fecha1;
    public $fecha2;

    public $mostrarPagina;
    public $disableButton=false;

    public function mount()
    {
        if ($this->filtroFecha=='no'){
            $this->filtroFecha=false;
        }else{
            $this->filtroFecha=true;
        }

        if ($this->meta){
            $this->refresh();
        }
    }

    public function refresh()
    {
        $hasta = 3;
        $this->mostrarPagina=$this->meta['current_page'];
        $this->meta['current_page']=1;
        $this->meta['desde'] = 1;
        $this->meta['next'] = false;
        $this->meta['hasta'] = false;
        $this->meta['anterior'] = false;
        if (isset($this->meta['total']) && ($this->meta['total']>=$this->meta['per_page'])){
            if ($this->meta['current_page']) {
                $this->meta['desde'] = $this->meta['current_page'] - 3;
                if ($this->meta['desde'] <= 0) {
                    $hasta = 5 - $this->meta['desde'];
                    $this->meta['desde'] = 1;
                }

                $this->meta['hasta'] = $this->meta['current_page'] + $hasta;
                if ($this->meta['hasta'] >= $this->meta['last_page']) {
                    $this->meta['hasta'] = $this->meta['last_page'];
                }

                if ($this->meta['hasta'] >= $this->meta['desde'] + 6) {
                    $this->meta['hasta'] = $this->meta['desde'] + 6;
                }

                if ($this->meta['current_page'] >= 2) {
                    $this->meta['anterior'] = $this->meta['current_page'] - 1;
                } else {
                    $this->meta['anterior'] = false;
                }
                if ($this->meta['current_page'] <= $this->meta['last_page'] - 1) {
                    $this->meta['next'] = $this->meta['current_page'] + 1;
                } else {
                    $this->meta['next'] = false;
                }
            }else{
                $this->meta['current_page']=1;
                $this->meta['desde'] = 1;
                $this->meta['next'] = false;
                $this->meta['hasta'] = false;
                $this->meta['anterior'] = false;
            }
       }
    }
    public function render()
    {
        return view('livewire.components.page-filters');
    }

    public function pageEnable($meta = null){
        $this->meta=$meta;
        $this->refresh();
        $this->disableButton=false;

    }

    public function openModal(){
        $this->emit('eventOpenModal');
    }
    public function pageUpdate($pageNum = 1)
    {

        $this->disableButton=true;
        $this->emit('page-update', $pageNum, $this->txtsearch, $this->fecha1, $this->fecha2);
        $this->meta['current_page'] = $pageNum;
    }
}
