<?php

namespace App\Http\Livewire\Data;
use App\Http\Livewire\BaseComponent;
use Illuminate\Support\Facades\Redis;
use App\Models\InverCartera;
use App\Models\InverCarteraEstrategia;
use App\Models\InverEstrategia;
use Illuminate\Support\Collection;

class Data extends BaseComponent
{
    public $id_moneda;
    public $Coin;
    public $arrCoin;
    public $formCoin;
    public $checkCoin;
    
    public $estrategias;
    public $li_estrategias = [];
    public $niveles=["estrategias simples", "Standard", "Minutos", "sombre EMA 200", "Venta Inmediata", "Otras"];
    public $arrEstra=array();
    public $colEstrategias;
    

    public $rs_minutos;
    public $rs_horas;
    public $rs_dias;

    public $coinTitulo='cargando...';
    public $paso=0;
    public $isBuying = false;

    public function mount($id)
    {
        $this->id_moneda=$id; 
        $this->arrCoin['simbolo']='cargando...';
    }

    public function inicio(){
        if ($this->paso==0){
            $this->paso=1;
            
            $this->Coin=InverCartera::where('id_mon', $this->id_moneda)->first();
            $this->coinTitulo=$this->Coin->simbolo;
            $this->arrCoin=$this->Coin->toArray();
            $this->formCoin=[
                'operando' => $this->arrCoin['operando'],
                'cant' => $this->arrCoin['cant'],
                'modo' => $this->arrCoin['modo'],
                'limites' => $this->arrCoin['limites'],
                'sembrar' => $this->arrCoin['sembrar'],
                'sembrar_inter' => $this->arrCoin['sembrar_inter'],
                'sembrar_grandes' => $this->arrCoin['sembrar_grandes'],
                'porc_minimo' => $this->arrCoin['porc_minimo'],
                'cant_decimales' => $this->arrCoin['cant_decimales'],
                'decimales_compra' => $this->arrCoin['decimales_compra'],
            ];
            $this->checkCoin=[
                'online' => $this->arrCoin['online'] ? true : false,
                'velocidad' => $this->arrCoin['velocidad'] ? true : false,
                'simulacion' => $this->arrCoin['simulacion'] ? true : false,
                'seg_op' => $this->arrCoin['seg_op'] ? true : false,
                'comprar' => $this->arrCoin['comprar'] ? true : false,
                'vender' => $this->arrCoin['vender'] ? true : false,
            ];   
            $this->estrategias();                            
        }    
       

               
    }


    public function comprarAhora(){
       $this->isBuying = true;
       Redis::set($this->id_moneda . '_comprar_ahora', 1); 
       $this->emit('mostrarMensaje', 'Compra iniciada.');
        sleep(2);
       $this->isBuying = false;
    }

    public function actCoin(){
        InverCartera::where('id_mon', $this->id_moneda)->update($this->formCoin);   
        $this->emit('mostrarMensaje', 'Moneda actualizada.');
    }


    public function updateCoin()
    {
        InverCartera::where('id_mon', $this->id_moneda)->update($this->checkCoin);
        $this->emit('mostrarMensaje', 'Actualizacion correcta.');
    }

    public function render()
    {
        return view('livewire.data.data');
    }


    public function estrategias()
    {
        $this->li_estrategias = [];
       //$this->estrategias = InverEstrategia::where('mostrar', 1)->get();
        $this->estrategias = InverEstrategia::where('mostrar', 1)->get()->keyBy('id_estrategia');
        $this->colEstrategias=  new Collection($this->estrategias);
        $rs_estra_activas = InverCarteraEstrategia::select('id_estrategia')
        ->where('id_cartera', $this->id_moneda)
        ->groupBy('id_estrategia')
        ->get()
        ->pluck('id_estrategia') // Pluck para obtener un array con los valores de id_estrategia
        ->toArray();
    
        $estrategiasActivas = array_combine($rs_estra_activas, $rs_estra_activas);     

        foreach ($this->estrategias as $est) {  
                   
            $this->arrEstra['e' . $est->id_estrategia]=0;
            $this->arrEstra['i' . $est->id_estrategia]=0;
            if (!isset($this->li_estrategias[$est->categoria])) {
                $this->li_estrategias[$est->categoria] = ''; // Inicializar la cadena
            }

            if (isset($estrategiasActivas[$est->id_estrategia])){
                $this->arrEstra['e' . $est->id_estrategia]=1;
            }            
            if (isset($estrategiasActivas[$est->id_estrategia]['instrumentacion'])){
                $this->arrEstra['i' . $est->id_estrategia]=1;
            }        
            $this->li_estrategias[$est->categoria] .= '
                <li style="background-color:#' . $est->color . '">
                    <label style="background-color:#fff;display:block;font-size: 11px;">' . $est->nombre . '</label>
                    <input type="checkbox" class="form-check-input" wire:model="arrEstra.e' . $est->id_estrategia . '" wire:click="checkEstra(' . $est->id_estrategia . ')">
                    <input type="checkbox" class="form-check-input" wire:model="arrEstra.i' . $est->id_estrategia . '" wire:click="checkInstru(' . $est->id_estrategia . ')">
                    <a href="javascript:void(0)" wire:click="mostrarInfoEstrategia(' . $est->id_estrategia . ')"><svg class="icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6V4m0 2a2 2 0 100 4m0-4a2 2 0 110 4m-6 8a2 2 0 100-4m0 4a2 2 0 110-4m0 4v2m0-6V4m6 6v10m6-2a2 2 0 100-4m0 4a2 2 0 110-4m0 4v2m0-6V4"></path></svg></a>
                </li>
            ';
        }
    }
    
    public function checkEstra($id){
        InverCarteraEstrategia::where('id_cartera', $this->id_moneda)
        ->where('id_estrategia', $id)
        ->delete();
        if ($this->arrEstra['e' . $id]){
            InverCarteraEstrategia::create([
                'id_cartera' => $this->id_moneda,
                'id_estrategia' => $id,
            ]);                        
        }

        $this->emit('mostrarMensaje', 'Estrategia actualizada');
        $this->skipRender();
        //InverCartera::where('id_mon', $this->id_moneda)->update($this->arrEstra); 
    }
    public function checkInstru($id){
        InverCarteraEstrategia::where('id_cartera', $this->id_moneda)
        ->where('id_estrategia', $id)
        ->delete();
        if ($this->arrEstra['e' . $id]){
            InverCarteraEstrategia::create([
                'id_cartera' => $this->id_moneda,
                'id_estrategia' => $id,
            ]);                        
        }

        $this->emit('mostrarMensaje', 'Estrategia actualizada');
        $this->skipRender();
        //InverCartera::where('id_mon', $this->id_moneda)->update($this->arrEstra); 
    } 
}
