<?php
namespace App\Http\Livewire\Emulador;

use App\Http\Livewire\BaseComponent;
use Illuminate\Support\Facades\Redis;
use App\Models\InverCartera;

class Grafico extends BaseComponent
{
    public $id_moneda;
    public $arrCoin;

    public $formato_x = '';
    public $decimales_cot = '';

    public $dataPoints_m_10d = '';
    public $arr_ops_10d = [];
    public $redisData;

    //protected $listeners = ['grafUpdated' => '$refresh'];
    //protected $listeners = ['operacionesActualizadas' => 'operacionesActualizadas'];

    public $mostrarGrafico=1;
    public $refrescos=0;

    
    public function mount($id_moneda)
    {
        $this->id_moneda = $id_moneda;
        $this->arrCoin['simbolo'] = 'cargando...';
        $this->formato_x = 'xValueFormatString: "DD-MM-YYYY HH:mm",';
        

        $coin = InverCartera::where('id_mon', $this->id_moneda)->first();
        $this->arrCoin = $coin->toArray();
        $this->decimales_cot = $this->arrCoin['cant_decimales'];
        for ($i = 1; $i <= $this->arrCoin['cant_decimales']; $i++) {
            $this->decimales_cot = $this->decimales_cot . "0";
        }
        $this->cargarDatapoints();
    }

    public function inicio()
    {
        $this->refrescos=$this->refrescos+1;
        $this->render();
        $redisDatos = json_decode(gzuncompress(Redis::get('rs_velas1m')));
        $dataPoints = [];

        foreach ($redisDatos as $vela) {
            if ($vela->fecha_stats != '') {
                $dataPoints[] = [
                    'x' => "new Date({$vela->fecha_stats}, {$vela->hora_stats})",
                    'y' => [$vela->open, $vela->high, $vela->low, $vela->close],
                    'label2' => "{$vela->fecha_stats}, {$vela->hora_stats}"
                ];
            }
        }

        // Convierte el array a formato JSON para pasarlo a JavaScript
        $dataPointsJson = json_encode($dataPoints);
        $this->emit('datosActualizados', $dataPoints);
    }


public function cargarDatapoints()
{
    $dataPoints = $this->formatDataPoints();
    $this->dataPoints_m_10d = $dataPoints;
}

    private function formatDataPoints()
    {
        $dataPoints_m_10d='';
        $redisDatos = json_decode(gzuncompress(Redis::get('rs_velas1m')));

        $cont=0;
        $dataPoints_m_10d.='[';
        foreach ($redisDatos as $vela) {
            if ($vela->fecha_stats != '') {
                list($year, $month, $day, $hour, $minute) = explode(',', $vela->fecha_stats . ',' . $vela->hora_stats);

                // Elimina espacios en blanco si los hay
                $year = ltrim($year, '0');
                $month = ltrim($month, '0');
                $day = ltrim($day, '0');
                $hour = ($hour === '00') ? '0' : ltrim($hour, '0');
                $minute = ($minute === '00') ? '0' : ltrim($minute, '0');

                $dataPoints_m_10d .= '{x: new Date(' . $year . ',' . ($month - 1) . ',' . $day . ',' . $hour . ',' . $minute . '),y:[' . $vela->open . ', ' . $vela->high . ', ' . $vela->low . ', ' . $vela->close . '],label2:"' . $vela->fecha_stats . ',' . $vela->hora_stats . '"},';                              
            }


            $cont=$cont+1;
            if ($cont==3){
           //     break;
            }
        }

        $dataPoints_m_10d = substr($dataPoints_m_10d, 0, -1);
        $dataPoints_m_10d.=']';
        
        return $dataPoints_m_10d;
    }


    public function cargarDatapoints2()
    {
      
        $this->skipRender();

    }

    public function operacionesActualizadas($datos)
    {
        $this->arr_ops_10d = $datos;
    }

    public function render()
    {
        $this->refrescos++;
        return view('livewire.emulador.grafico');
    }




}