<?php

namespace App\Http\Livewire;

use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Livewire\Component;
use App\Services\MecubroService;

class Profile extends Component
{
    public $alertTxt=''; public $showSavedAlert = false;  public $showErrorAlert = false;

    public function rules() {

    }

    public function mount() {
        $this->form=array();
        $this->form['name']=session('usr_name');
        $this->form['phone']=session('usr_phone');
     }

    public function save(MecubroService $mecubroService)
    {
        $this->showSavedAlert = false; $this->showErrorAlert=false;

        session(['usr_name' => $this->form['name']]);

        $result=$mecubroService->userInfoUpdate($this->form, session('usr_id'));
        isset($result['msg'])
            ? $this->alertTxt=$result['msg']
            : $this->alertTxt='';
        $result['result']
            ? $this->showSavedAlert = true
            : $this->showErrorAlert = true;
    }

    public function render()
    {
        return view('livewire.profile');
    }
}
