<?php

namespace App\Http\Livewire\Siniestros;

use App\Http\Livewire\BaseComponent;
use App\Services\MecubroService;
use Livewire\WithFileUploads;
use Livewire\TemporaryUploadedFile;
use File;

class SiniestrosMensajes extends BaseComponent
{
    use WithFileUploads;
    public $attach;
    public $attachType = 'medical_certificate';
    public $siniestroMensajes;
    public $msg = '';
    public $msgId;
    public $fileSend = false;
    protected $listeners = ['refreshComponent' => '$refresh'];
    public $cont;
    public $siniestro;
    public $claimFiles;
    public $siniestroId;
    public $anotaciones;


    public $questionsTrad=[
        'task'                  =>  "Tarea que realizaba",
        'in_itinere'            =>  "¿El accidente fue camino al trabajo?",
        'working_hours'         =>  "¿El accidente fue en horario de trabajo?",
        'working_height'        =>  "¿Estabas realizando un trabajo en altura? Indica los metros",
        'injuries'              =>  "¿Tuviste alguna lesión grave?",
        'fracture'              =>  "¿Tuviste alguna fractura?",
        'medical_assistance'    =>  "¿Recibiste atención médica?",
        'hospital_assistance'   =>  "¿Te hiciste atender en una clínica u hospital?",
        'witness'               =>  "¿Hubo testigos? Colocar los datos",
    ];

    public function mount(MecubroService $mecubroService, $id)
    {
        $this->siniestroId = $id;
        $this->refresh($mecubroService);
    }

    function procRespuesta($respuesta){
        return 'abc';
    }


    public function refresh($mecubroService)
    {
        $result = $mecubroService->siniestros(['filter[id][eq]' => $this->siniestroId]);
        if (isset($result['data'][0])){
            $this->siniestro = $result['data'][0];

            $result = $mecubroService->siniestroMensajes($this->siniestroId, ['limit' => 250]);
            $this->siniestroMensajes = array_reverse($result['data']);

            $result = $mecubroService->claimFiles($this->siniestroId);
            $this->claimFiles = $result['data'];
        }
    }
    public function render(MecubroService $mecubroService)
    {
        if ($this->siniestro){
            return view('livewire.siniestros.siniestros-mensajes');
        }else{
            return view('livewire.error500');
        }


    }

    public function save(MecubroService $mecubroService)
    {
        $result = $mecubroService->siniestroMensajesNew(['message' => $this->msg, 'type' => 'comments'], $this->siniestroId);
        $result['result'] ? $this->refresh($mecubroService) : ($this->showErrorAlert = true);
    }

    public function anotacionesSave(MecubroService $mecubroService)
    {
        $result = $mecubroService->siniestroAnotacionesSave($this->anotaciones, $this->siniestroId);

      //  $result['result'] ? $this->refresh($mecubroService) : ($this->showErrorAlert = true);
    }

    public function attachSend(MecubroService $mecubroService)
    {
        $tempFile = TemporaryUploadedFile::createFromLivewire($this->attach->getFilename());
        $result = $mecubroService->siniestroDocummentSend(['type' => $this->attachType, 'description' => 'Archivo Adjunto'], $tempFile, $this->siniestro['id']); // $this->attach->temporaryUrl()]);

        if ($result['result']) {
            $this->attachTmpDelete();
            $this->refresh($mecubroService);
        }
    }

    public function attachTmpDelete()
    {
        $this->reset('attach', 'attachType');
    }

    public function attachDelete(MecubroService $mecubroService, $fileId)
    {
        $result = $mecubroService->claimFileDelete($fileId, $this->siniestroId);
        $result['result'] ? $this->refresh($mecubroService) : ($this->showErrorAlert = true);
    }
}
