<?php

namespace App\Http\Livewire\Soporte;
use App\Http\Livewire\BaseComponent;
use App\Models\SoporteTicket;
use App\Models\SoporteMsg;

class Soporte extends BaseComponent
{

    public $tickets;
    public $chatActivo;
    public $soporteMsg;
    public $ticketActivo;
    public $msgSend;
    public function mount()
    {
        $this->ticketActivo['cargado']=0;
        $this->refresh();
        //dd($this->tickets);
    }

    public function refresh()
    {
        $this->tickets=SoporteTicket::all()->toArray();
        if (isset($this->ticketActivo['id'])){
            $this->soporteMsg=SoporteMsg::where('id_ticket','=',  $this->ticketActivo['id'])->get()->toArray();
        }

    }

    public function render()
    {
        return view('livewire.soporte.soporte');
    }

    public function cargarChat($id){
        $this->ticketActivo=SoporteTicket::where('id','=',$id )->first()->toArray();
       // $this->chatActivo['name']=$ticketActivo['nombre_invitado'];
       // $this->chatActivo['asunto']=$ticketActivo['asunto'];
        $this->ticketActivo['cargado']=1;
        SoporteTicket::where('id','=',$id )->update(['visto_admin'=>1]);

        $this->soporteMsg=SoporteMsg::where('id_ticket','=', $id)->get()->toArray();
        SoporteMsg::where('id_ticket','=',$id )->update(['visto'=>1]);

        $this->refresh();
        $this->render();
        $this->dispatchBrowserEvent('scroll-abajo');
    }

    public function enviarMsg(){
        SoporteMsg::create([
            "id_ticket" => $this->ticketActivo['id'],
            "id_cli" => $this->ticketActivo['id_cli'],
            "mensaje" => $this->msgSend,
            "quien" => 1
        ]);
        $this->msgSend='';
        $this->refresh();
        $this->dispatchBrowserEvent('scroll-abajo');
    }
}
