<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InverOrden extends Model
{
    protected $table='inver_ordenes';
    protected $primaryKey = 'id_orden';
    use HasFactory;


    public function scopeCustomStats($query)
    {
        return $query->selectRaw(
            '*, ' .
            'DATE_FORMAT(fecha_creacion, "%Y,%m,%e") AS fecha_stats, ' .
            'DATE_FORMAT(fecha_creacion, "%H,%i") AS hora_stats, ' .
            'DATE_FORMAT(fecha_finalizada, "%Y,%m,%e") AS fecha_stats_venta, ' .
            'DATE_FORMAT(fecha_finalizada, "%H,%i") AS hora_stats_venta'
        );
    }

}
