<?php
class MonedaStats
{
	public $id_moneda;
	public $periodo;
	public $velas;

	public $ema8_dire;
	public $ema8_vs21;
	public $ema8_vs200;

	public $ema21_dire;
	public $ema21_vs200;

	public $ema200_dire;
	public $ema200_dire_3h;

	public $mechas_sup;
	public $mechas_inf;

	public $macd_lado;
	public $macd_sec_tipo;
	public $macd_sec_cant;
	public $macd_velas_color;
	public $macd_completo;
	public $macd_minimos_desc = 0;
	public $macd_minimos_asc = 0;

	public $macd_ant_rs;
	public $macd_ant_lado;
	public $macd_ant_sec_tipo;
	public $macd_ant_sec_cant;
	public $macd_ant_velas_color;
	public $macd_ant_completo;

	public $ema8vs21_min15v;
	public $ema8vs21_max15v;
	public $max4v;
	public $max4v_close;

	public $mins_sec;
	public $mins_sec_last;

	public $arr_status = array(); // Si en algun error se pasa a 0 el sistema no se ejecutara // ["status"]["log"]
	public $cot_minima_12h;
	public $cot_minima_12h_posc;

	public $cot_max_4h;
	public $cot_max_4h_posc;

	public $cot_minima_4h;
	public $cot_minima_4h_posc;

	public $cot_max_35m;

	public $cot_minima_35m;
	public $cot_minima_35m_posc;

	public $arr_velas_rojas = array(); //[0] ultima/actual luego mas lejanas ["color"] ["Porc"] ["mecha_sup"] ["mecha_inf"]
	public $arr_velas_rojas_txt; //usado para mostrar en visor
	public $velas_rojas_consecutivas = 0;
	public $velas_rojas_de_10 = 0; // velas rojas en las ultimas 10 velas
	public $velas_rojas_de_6 = 0;

	public $macd_maximos = '';
	public $macd_minimos = '';
	public $arr_niveles = array();

	public $soporte_inf = 0;
	public $soporte_sup = 0;

	public $soporte_inf_toques = 0;

	public function __construct($velasData, $periodo, $id_moneda)
	{
		$this->arr_status["status"] = 1;
		$this->arr_status["log"] = '';
		$this->periodo = $periodo;
		$this->id_moneda = $id_moneda;
		$this->velas = $velasData;

		if ($periodo == 'm') {
			//	$this->arr_niveles=obtenerNiveles($this->velas);
			//	$this->soportes();
		}

		//$this->mechas();
		//$this->calcularToques();
		//$this->validar();
	}

	private function calcularToques()
	{
		$soporte_inf = $cl_soportes->arr_soportes_inf[0]["nivel"];
		$soporte_inf = $soporte_inf + ($soporte_inf / 100) * 0.2;
		$toques = 0;
		for ($i = 0; $i <= 50; $i++) {
			if (is_numeric($this->arr_macds["neg"][$i]["low"]) and $this->arr_macds["neg"][$i]["low"] <= $soporte_inf) {
				$toques = $toques + 1;
			}
		}
		$this->soporte_inf_toques = $toques;
	}



	private function mechas()
	{
		$ultima_vela = array_key_last($this->velas);
		$this->mechas_sup[0] = porc2CotizPorc($this->velas[$ultima_vela - 1]["high"], $this->velas[$ultima_vela - 1]["close"], $this->velas[$ultima_vela - 1]["low"], 3);
		$this->mechas_sup[1] = porc2CotizPorc($this->velas[$ultima_vela - 2]["high"], $this->velas[$ultima_vela - 2]["close"], $this->velas[$ultima_vela - 2]["low"], 3);
		$this->mechas_sup[2] = porc2CotizPorc($this->velas[$ultima_vela - 3]["high"], $this->velas[$ultima_vela - 3]["close"], $this->velas[$ultima_vela - 3]["low"], 3);
		$this->mechas_sup[3] = porc2CotizPorc($this->velas[$ultima_vela - 4]["high"], $this->velas[$ultima_vela - 4]["close"], $this->velas[$ultima_vela - 4]["low"], 3);
		$this->mechas_sup[4] = porc2CotizPorc($this->velas[$ultima_vela - 5]["high"], $this->velas[$ultima_vela - 5]["close"], $this->velas[$ultima_vela - 5]["low"], 3);
		$this->mechas_sup[5] = porc2CotizPorc($this->velas[$ultima_vela - 6]["high"], $this->velas[$ultima_vela - 6]["close"], $this->velas[$ultima_vela - 6]["low"], 3);
		$this->mechas_sup[6] = porc2CotizPorc($this->velas[$ultima_vela - 7]["high"], $this->velas[$ultima_vela - 7]["close"], $this->velas[$ultima_vela - 7]["low"], 3);
		$this->mechas_sup[7] = porc2CotizPorc($this->velas[$ultima_vela - 8]["high"], $this->velas[$ultima_vela - 8]["close"], $this->velas[$ultima_vela - 8]["low"], 3);
	}

	private function soportes()
	{
		global $moneda;
		$cot = $moneda->last_close;
		$this->soporte_inf = $cot - ($cot / 100) * 5;
		$this->soporte_sup = $cot + ($cot / 100) * 5;
		$hay_soporte_inf = 0;
		$hay_soporte_sup = 0;
		foreach ($this->arr_niveles as $nivel) {
			if ($nivel["nivel"] > $cot and $nivel["nivel"] < $this->soporte_sup) {
				$this->soporte_sup = $nivel["nivel"];
				$hay_soporte_inf = 1;
			}
			if ($nivel["nivel"] < $cot and $nivel["nivel"] > $this->soporte_inf) {
				$this->soporte_inf = $nivel["nivel"];
				$hay_soporte_sup = 1;
			}
		}

		if ($hay_soporte_inf == 0) {
			$this->soporte_inf = 0;
		}
		if ($hay_soporte_sup == 0) {
			$this->soporte_sup = 0;
		}
	}



	private function validar()
	{
		return true;
		if ($this->ema8_dire <= -20 or $this->ema21_dire >= 20) {
			$this->arr_status["status"] = 0;
			$this->arr_status["log"] .= 'Ema 8 falla, valor: ' . $this->ema8_dire;
		}
		if ($this->ema8_vs200 <= -20 or $this->ema8_vs200 >= 20) {
			$this->arr_status["status"] = 0;
			$this->arr_status["log"] .= 'Ema 8vs200 falla, valor: ' . $this->ema8_dire;
		}
	}


}

?>