<div wire:id="graf-container">
    <div id="chartMinutos" style="height: 500px; width: 100%; clear:both"></div>


    <script>
        var chart; // Declarar chart como una variable global
        document.addEventListener('livewire:load', function() {
            function crearGrafico() {

                chart = new CanvasJS.Chart("chartMinutos", {

                    title: {
                        text: "Minutos 10d"
                    },
                    legend: {
                        cursor: "pointer",
                        itemclick: function(e) {
                            //console.log("legend click: " + e.dataPointIndex);
                            //console.log(e);
                            if (typeof(e.dataSeries.visible) === "undefined" || e.dataSeries.visible) {
                                e.dataSeries.visible = false;
                            } else {
                                e.dataSeries.visible = true;
                            }

                            e.chart.render();
                        }
                    },
                    axisY: {
                        gridThickness: 0,
                        tickLength: 0,
                        lineThickness: 0,
                        includeZero: false,
                        prefix: "$",
                        labelFormatter: function() {
                            return "";
                        }
                    },
                    axisY2: {
                        includeZero: false,
                        prefix: "",
                        labelFormatter: function() {
                            return "";
                        }
                    },
                    zoomEnabled: true,
                    zoomType: "x",
                    data: [{
                            type: "candlestick",
                            axisYType: "secondary",
                            // click: onClickSeg,
                            {!! $formato_x !!}
                            risingColor: "green",
                            fallingColor: "red",
                            yValueFormatString: "$#,##0.{!! $decimales_cot !!}",
                            dataPoints: []
                        },


                    ]
                });



                var datapoints = {!! $dataPoints_m_10d !!};
               // console.log(datapoints);
                chart.options.data[0].dataPoints = datapoints; // Asigna el arreglo de objetos
                chart.render();
            }

            Livewire.on('datosActualizados', function(data) {
               // console.log(data);
                var dataPoints = eval(
                data); // [{x: new Date(2023,7,27,9,7),y:[216.80000000, 216.80000000, 216.70000000, 216.70000000],label2:"2023,08,27,09,07"},{x: new Date(2023,7,27,9,8),y:[216.80000000, 216.80000000, 216.70000000, 216.80000000],label2:"2023,08,27,09,08"},{x: new Date(2023,7,27,9,9),y:[216.80000000, 216.80000000, 216.70000000, 216.70000000],label2:"2023,08,27,09,09"},{x: new Date(2023,7,27,9,10),y:[216.80000000, 216.80000000, 216.70000000, 216.80000000],label2:"2023,08,27,09,10"},{x: new Date(2023,7,27,9,11),y:[216.80000000, 216.90000000, 216.70000000, 216.90000000],label2:"2023,08,27,09,11"},{x: new Date(2023,7,27,9,12),y:[216.80000000, 216.90000000, 216.80000000, 216.90000000],label2:"2023,08,27,09,12"}];
                chart.options.data[0].dataPoints = dataPoints; // Asigna el arreglo de objetos
                chart.render();
            });



            Livewire.on('operacionesActualizadas', function (data2) {
                
                operaciones=JSON.parse(data2);
             //    console.log(operaciones[0]);
                // Elimina todos los datasets excepto el primero (índice 0)
                //console.log(eval(operaciones[0]));
                chart.options.data.splice(1);
                console.log(operaciones);
                // Crea nuevos datasets con las órdenes recibidas
                for (var i = 0; i < operaciones.length; i++) {
                    var tmp= eval('[' + operaciones[i] + ']');
                     var numeroOperacion = tmp[0].indexLabel;
                    var dataset = {
                    type: "line",
                    indexLabelFontColor: "black",
                    indexLabelFontSize: 19,
                   axisYType: "secondary",
                    {!! $formato_x !!}
                    showInLegend: true,
                    legendText: numeroOperacion,
                    markerSize: 20,
                    yValueFormatString: "$#,##0.{!! $decimales_cot !!}",
                    dataPoints:tmp,
                        // Otras configuraciones del dataset
                    };

                    chart.options.data.push(dataset);
                }

                chart.render();
            });



            crearGrafico();

        })
    </script>



</div>
