<div>
    <title>Mecubro | Siniestros</title>
    @if (session()->has('message-danger'))
        <div class="alert alert-danger">
            {{ session('message-danger') }}
        </div>
    @endif
    @livewire('components.page-filters', ['meta' => $meta, 'filters' => 'id, Doc, usuario o Desc'])
    <div wire:loading.block class="alert alert-info" role="alert">
        Actualizando Estado de la operacion... <img src="/assets/img/loading.gif" width="35px">
    </div>
    <div class="message-wrapper border-0 bg-white shadow rounded mb-1" style="clear:both">
        <div class="card-body d-flex align-items-center flex-wrap flex-lg-nowrap py-0">
            <div class="col-1 align-items-center px-0 d-none d-lg-flex" style="width: 65px">ID</div>
            <div class="col-4 col-lg-1 ps-0 ps-lg-3 pe-lg-3" style="width: 130px">Fecha</div>
            <div class="col-4 col-lg-1 ps-0 ps-lg-3 pe-lg-3">Estado</div>
            <div class="col-1 col-lg-1 ps-0 ps-lg-3 pe-lg-3">Riesgo</div>
            <div class="col-4 col-lg-2 ps-0 ps-lg-3 pe-lg-3">Asegurado</div>

            <div class="col-4 col-lg-1 ps-0 ps-lg-3 pe-lg-3">Seguro</div>
            <div class="col-4 col-lg-1 ps-0 ps-lg-3 pe-lg-3">Declarado</div>

        </div>
    </div>
    @if (!$siniestros || $siniestros == null)
        <div class="alert alert-success" role="alert">
            <i class="fa fa-superpowers" aria-hidden="true"></i>Sin resultados para la busqueda generada.
        </div>
    @else




    @foreach ($siniestros as $siniestro)
    <div class="message-wrapper border-0 bg-white shadow rounded mb-1" style="clear:both; font-size:13px">
        <div class="card hover-state border-bottom rounded-0 rounded-top my-2">
            <div class="card-body d-flex align-items-center flex-wrap flex-lg-nowrap py-0">
                <div class="col-6 col-lg-1 align-items-center px-0 d-lg-flex" style="width: 65px">
                    AP{{ $siniestro['id'] }} <span class="flecha">></span>
                </div>
                <div class="col-6 col-lg-2 ps-0 ps-lg-3 pe-lg-3" style="width: 130px">
                    {{ $this->getFecha($siniestro['date']) }} <br>
                    {{ $siniestro['hour'] }}
                </div>
                <div class="col-9 col-lg-1 ps-0 ps-lg-2 pe-lg-2">
                    <button type="button"
                        wire:click="changeStatus({{ $siniestro['id'] }},'{{ $siniestro['status_nice'] }}')"
                        class="btn btn-block mecubro-btn1" data-bs-toggle="modal"
                        data-bs-target="#modalNotification">{{ $siniestro['status_nice'] }}</button>

                </div>
                <div class="col-6 col-lg-2 ps-0 ps-lg-3 pe-lg-3" style="width: 130px">
                    {{ $siniestro['risk_type']['name'] }}
                </div>

                <div class="col-6 col-lg-2 ps-0 ps-lg-3 pe-lg-3">
                    {{ $siniestro['insurance_risk']['insured_entity']['name_nice'] }} <br> {{$siniestro['insurance_risk']['insured_entity']['document_nice']}}
                </div>
                <div class="col-6 col-lg-2 ps-0 ps-lg-3 pe-lg-3" style="width: 130px">
                    {{ $siniestro['insurance_risk']['id'] }}
                    <img src="{{ $siniestro['coverage']['policy']['company']['logo_filename'] }}"  onerror="this.src = '/assets/img/sf.jpg';"
                    class="avatar-sm rounded-circle me-3"
                    alt="{{ $siniestro['coverage']['policy']['company']['name'] }}">
                </div>


                <div class="col-6 col-lg-2 ps-0 ps-lg-3 pe-lg-3" style="width: 130px">
                    {{ $this->getFecha($siniestro['created_at'],1) }}
                </div>

                <div class="col-12 col-lg-3 ps-0 ps-lg-3 pe-lg-3">
                             <a type="button" class="btn btn-block mecubro-btn1"
                        href="/siniestros-mensajes/{{ $siniestro['id'] }}">Historial / msj</a>
                </div>


                <div class="col-3 col-lg-1 d-flex align-items-center justify-content-end px-0 order-lg-2">
                    <div class="dropdown ms-3">
                        <button type="button" class="btn btn-sm fs-6 px-1 py-0 dropdown-toggle"
                            id="dropdownMenuLink" data-bs-toggle="dropdown" aria-expanded="false">
                            <svg class="icon icon-xs" fill="currentColor" viewBox="0 0 20 20"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M6 10a2 2 0 11-4 0 2 2 0 014 0zM12 10a2 2 0 11-4 0 2 2 0 014 0zM16 12a2 2 0 100-4 2 2 0 000 4z">
                                </path>
                            </svg>
                        </button>
                        <div class="dropdown-menu dashboard-dropdown dropdown-menu-start mt-2 py-1">
                            <a class="dropdown-item d-flex align-items-center"
                                href="/siniestros-mensajes/{{ $siniestro['id'] }}">
                                <svg class="dropdown-icon text-gray-400 me-2" fill="currentColor"
                                    viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M4 3a2 2 0 100 4h12a2 2 0 100-4H4z"></path>
                                    <path fill-rule="evenodd"
                                        d="M3 8h14v7a2 2 0 01-2 2H5a2 2 0 01-2-2V8zm5 3a1 1 0 011-1h2a1 1 0 110 2H9a1 1 0 01-1-1z"
                                        clip-rule="evenodd"></path>
                                </svg> Chat / Mensajes
                            </a>
                            <div role="separator" class="dropdown-divider my-1"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endforeach



    @endif
    @if ($modal_open == true)
        <!-- Modal Content -->
        <div class="modal fade show" id="modalNotification" tabindex="-1" role="dialog"
            aria-labelledby="modalTitleNotify" aria-modal="true" style="display: block;">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <p class="modal-title" id="modalTitleNotify">Modificar estado de un siniestro.</p>
                        <button type="button" wire:click="cerrarModal()" class="btn-close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="py-3 text-center">
                            Estado actual: <strong>{{ $siniestro_activo_estado }}</strong>
                            <h2 class="h4 modal-title my-3">¿Que estado desea asignar?</h2>
                            <ul style="list-style-type:none">
                                @foreach ($siniestros_estados as $estado)
                                    @if ($estado['id'] != $siniestro_activo_id)
                                        <li class="page-item">
                                            <button class="page-link btn-status" href="#"
                                                wire:click="changeStatusSave({{ $estado['id'] }})"
                                                wire:loading.attr="disabled">{{ $estado['name'] }}</button>
                                        </li>
                                    @endif
                                @endforeach
                            </ul>
                        </div>
                        <div wire:loading.block class="alert alert-success" role="alert">
                            Actualizando Estado...
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-backdrop fade show"></div>
        <!-- Fin modal -->
    @endif
</div>
