<div>
<title>Tacticas y estrategias | Criptobots.com</title>
    <style>
        .titulos {
            font-weight: bold;
            color: #f00;
        }

        .cont-item {
            margin-right: 10px;        
            width: calc(100% / 6 - 10px); /* Ancho para ocupar 1/6 de la pantalla y dejar margen */
        }

        .empty-tactica {
            width: calc(100% / 6 - 10px); /* Ancho para el espacio de tácticas sin título */
            height: 1px; /* Altura mínima para que ocupe espacio sin afectar la visualización */
        }

        /* Colores de borde según la estrategia del item */
        .comprar {
            border-color: green;
        }

        .vender {
            border-color: red;
        }

        /* Estilo para el div del primer item de cada táctica */
        .titulo-tactica {
            background-color: #f00; /* Color brillante */
            width: 8px; /* Ancho de 8px para mostrarlo como separador */
            margin-bottom: 5px; /* Margen inferior para separar el título de los items */
            color: transparent; /* Oculta el texto */
        }

        /* Estilo para los items que no son el primer item de cada táctica */
        .item-no-titulo {
            margin-top: 15px; /* Margen superior para separar los items */
        }

        /* Estilo para los items sin título de táctica */
        .item-sin-titulo {
            margin-top: 15px; /* Margen superior para separar los items */
            visibility: hidden; /* Oculta el contenido, pero mantiene el espacio */
        }

        /* Estilo para las opciones de cada item */
        .cont-opciones {
            text-align: center;
            font-size: 14px; /* Tamaño de fuente de las opciones */
        }

        /* Estilo para el separador de táctica */
        .tactica-separador {
            background: #3d3d3d;
            color: #fff;
            text-align: center;
            font-size: 20px;
            letter-spacing: 0.6px;
        }
        .card-body{
            padding: 5px;
        }
        .verde{
            color:#008b00;
            font-weight: bold;
        }
        .minutos{
            background-color: #FFE6E6;
        }
        .horas{
            background-color: #FFCCCC;
        }
        .dias{
            background-color: #FFC0CB;
        }
        .otros{
            background-color: #FFB3B3;
        }
    </style>

    <div class="row">
        <p>    
            @if(isset($dataTacticas['timestamp']))
                <p>Última actualización: {{ date('d-m-Y H:i:s', $dataTacticas['timestamp']) }} <strong>{{ $txtActualizado }}</strong></p>
            @else
            <p>No hay datos disponibles</p>
            @endif</p>
        <div class="col-12">
            <div class="d-flex flex-wrap">
                @php
                    $tacticaActual = null;
                @endphp
                @foreach ($dataTacticas['comprar'] as $tactica)
                    @if (isset($tactica['nombre']) && $tacticaActual != $tactica['nombre'])
                        @php
                            $tacticaActual = $tactica['nombre'];
                        @endphp
                    @endif

                    @if (isset($tactica['items']) && is_array($tactica['items']) && count($tactica['items']) > 0)
                        @foreach ($tactica['items'] as $itemId=>$item)

                        @php
                        $opcionesOrdenados = collect($item['opciones'])->sortBy('periodo')->values();

                        $opcionesOrdenados = collect($item['opciones'])->sortBy(function ($opcion) {
                            // Definir un valor numérico para cada categoría
                            switch ($opcion['periodo']) {
                                case 'minutos':
                                    return 1;
                                case 'horas':
                                    return 2;
                                case 'dias':
                                    return 3;
                                case 'otros':
                                    return 4;                                    
                                default:
                                    return 5;
                            }
                        })->values(); 
                        
                        @endphp

                            <div class="cont-item @if(!$loop->first) item-no-titulo @endif @if(isset($item['estrategia'])){{ $item['estrategia'] }}@endif">
                                @if ($loop->first)
                                    <div class="card mb-2">
                                        <div class="card-body">
                                            <div class="tactica-separador">{{ $tacticaActual }}</div>
                                                                                  
                                             {{ $item['nombre'] }} ({{ isset($dataTacticas['comprar']['puntajes'][$itemId]['puntaje']) ? $dataTacticas['comprar']['puntajes'][$itemId]['puntaje'] : 'N/A' }} de {{ isset($dataTacticas['comprar']['puntajes'][$itemId]['cant_opciones']) ? $dataTacticas['comprar']['puntajes'][$itemId]['cant_opciones'] : 'N/A' }})                                            

                                            @foreach ( $opcionesOrdenados as $opcion)
                                                <div class="cont-opciones {{$opcion['periodo']}} @if($opcion['puntaje']==1)verde @endif">
                                                    {{ $opcion['txt'] }}
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                @else
                                    <div class="card mb-2">
                                        <div class="card-body">
                                            <div class="tactica-separador"></div>
                                                       
                                            {{ $item['nombre'] }} ({{ isset($dataTacticas['comprar']['puntajes'][$itemId]['puntaje']) ? $dataTacticas['comprar']['puntajes'][$itemId]['puntaje'] : 'N/A' }} de {{ isset($dataTacticas['comprar']['puntajes'][$itemId]['cant_opciones']) ? $dataTacticas['comprar']['puntajes'][$itemId]['cant_opciones'] : 'N/A' }})                                            
                                            @foreach ( $opcionesOrdenados as $opcion)
                                                <div class="cont-opciones {{$opcion['periodo']}} @if($opcion['puntaje']==1)verde @endif">
                                                    {{ $opcion['txt'] }}
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                @endif
                            </div>
                        @endforeach
                    @else
                        <div class="cont-item item-sin-titulo">
                            <div class="tactica-separador">&nbsp;</div>
                            <div class="card mb-2">
                                <div class="card-body">
                                    &nbsp;
                                </div>
                            </div>
                        </div>
                    @endif
                @endforeach

                <!-- Espacio para tácticas sin título -->
                <div class="cont-item col-auto empty-tactica"></div>
            </div>
        </div>
    </div>
    <div wire:poll.3000ms="pollDataTacticas"></div>
</div>


