<div>
    <title>Perfil de usuario | {{$usuario['name']}}</title>
    @if (session()->has('message-danger'))
        <div class="alert alert-danger">
            {{ session('message-danger') }}
        </div>
    @endif
    @if (session()->has('message-success'))
        <div class="alert alert-success">
            {{ session('message-success') }}
        </div>
    @endif
        <div class="row">
            <div class="col-12 col-xl-8">
                <div class="card card-body border-0 shadow mb-4">
                    <h2 class="h5 mb-4">Informacion general</h2>
                    <form wire:submit.prevent="actualizarUsuario" action="#" method="POST">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <div>
                                    <label for="first_name">Nombre</label>
                                    <input class="form-control" id="first_name" type="text"
                                        placeholder="Ingresa tu nombre" wire:model="usuario.name" required>
                                </div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <div>
                                    <label for="last_name">Apellido</label>
                                    <input class="form-control" wire:model="usuario.entity.last_name" type="text"
                                        placeholder="Ingresa Apellido">
                                </div>
                            </div>
                        </div>
                        <div class="row align-items-center">
                            <div class="col-md-6 mb-3">
                                <div class="form-group">
                                    <label for="email">Email</label>
                                    <input wire:model="usuario.email" class="form-control" id="email" type="email"
                                        placeholder="Ingrese cuenta de correo" disabled>
                                </div>
                                @error('email') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="gender">Genero</label>
                                <select class="form-select mb-0" id="gender" aria-label="Gender select example" wire:model="usuario.entity.gender">
                                    <option selected>Elegir...</option>
                                    <option value="f">Femenino</option>
                                    <option value="m">Masculino</option>
                                    <option value="o">Otros</option>
                                </select>
                                @error('user.gender') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-4 mb-3">
                                <div class="form-group">
                                    <label for="address">Documento</label>
                                    <input wire:model="usuario.entity.document" class="form-control" type="text" placeholder="Ingrese documento">
                                </div>
                                @error('usuario.documento') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                            <div class="col-sm-4 mb-3">
                                <div class="form-group">
                                    <label for="number">Telefono</label>
                                    <input class="form-control" id="number" wire:model="usuario.phone" type="number"
                                        placeholder="Telefono" >
                                </div>
                                @error('user.number') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                            <div class="col-sm-4 mb-3">
                                <div class="form-group">
                                    <label for="number">Pais</label>
                                    <select class="form-select mb-0" id="country" wire:model="usuario.country.id">
                                        @foreach ($paises as $pais)
                                            <option value="{{$pais['id']}}">{{$pais['name']}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                @error('user.number') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                        </div>

                        <div class="mt-3">
                            <button type="submit" wire:click='actualizarUsuario' class="btn btn-gray-800 mt-2 animate-up-2">Actualizar info</button>
                        </div>
                    </form><br><br><br><br><br><br>

                </div>
            </div>
            <div class="col-12 col-xl-4">
                <div class="row">
                    <div class="col-12 mb-4">


                        <div class="card card-body border-0 shadow mb-4">
                            <h2 class="h5 mb-4">Entidad Owner</h2>
                            <div class="d-flex align-items-center">


                                @if ($usuario['entity'])
                                <div class="me-3"> <img class="rounded" src="https://ui-avatars.com/api/?background=random&amp;rounded=true&amp;bold=true&amp;name=Liliana+Fernandez" alt="change avatar"></div>
                                <div class="file-field">
                                    <div class="d-flex justify-content-xl-center ms-xl-3">
                                        <div class="d-flex">
                                            <div class="d-md-block text-left">
                                                <div class="text-gray small">#{{ $usuario['entity']['id']}} - {{$usuario['entity']['name_nice']}} </div>
                                                <div class="fw-normal text-dark mb-1">{{$usuario['entity']['document_nice']}}</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @else
                                    <div>No posee entidad Owner</div>
                                @endif

                            </div>
                        </div>

                        <div class="card card-body border-0 shadow mb-4">
                            <h2 class="h5 mb-4">Entidades relacionadas</h2>
                            @foreach ($entidades as $valor)
                            <div class="d-flex align-items-center">
                                <div class="me-3"> <img class="rounded" src="https://ui-avatars.com/api/?background=random&amp;rounded=true&amp;bold=true&amp;name=Liliana+Fernandez" alt="change avatar"></div>
                                <div class="file-field">
                                    <div class="d-flex justify-content-xl-center ms-xl-3">
                                        <div class="d-flex">
                                            <div class="d-md-block text-left">
                                                <div class="text-gray small">#{{$valor['id']}} - {{$valor['name_nice']}} </div>
                                                <div class="fw-normal text-dark mb-1">{{$valor['document_nice']}}</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>

                        <div class="card card-body border-0 shadow mb-4">
                            <h2 class="h5 mb-4">Billeteras</h2>
                            @foreach ($billeteras as $valor)
                            <div class="d-flex align-items-center">
                                <div class="me-3"> <img class="rounded" src="https://ui-avatars.com/api/?background=random&amp;rounded=true&amp;bold=true&amp;name=Liliana+Fernandez" alt="change avatar"></div>
                                <div class="file-field">
                                    <div class="d-flex justify-content-xl-center ms-xl-3">
                                        <div class="d-flex">
                                            <div class="d-md-block text-left">
                                                <div class="text-gray small">#{{$valor['id']}} - {{$valor['entity']['name_nice']}} (#{{$valor['entity']['id']}}) </div>
                                                <div>Balance: {{ $valor['balance_nice'] }}</div>
                                                <div class="fw-normal text-dark mb-1"><a wire:click="$emit('cargar-billetera',{{ $valor['id'] }})">Cargar Billetera</a> -<a  wire:click="showMovements({{ $valor['id'] }}, '{{ $valor['entity']['first_name'] }}')"> Movimientos</a></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endforeach

                        </div>

                    </div>
                </div>
            </div>
        </div>
        @livewire('operaciones.transferencias', ['user_id' => $usuario['id']])
        @livewire('components.wallet-movements')
        @livewire('components.crear-transferencia-bancaria')
    </div>
