<div>
    <title>Mecubro | Seguros</title>
    <?php if(session()->has('message-danger')): ?>
        <div class="alert alert-danger">
            <?php echo e(session('message-danger')); ?>

        </div>
    <?php endif; ?>
    <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('components.page-filters', ['meta' => $meta, 'filters' => 'id|fechas|documento|estado'])->html();
} elseif ($_instance->childHasBeenRendered('l845541679-0')) {
    $componentId = $_instance->getRenderedChildComponentId('l845541679-0');
    $componentTag = $_instance->getRenderedChildComponentTagName('l845541679-0');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('l845541679-0');
} else {
    $response = \Livewire\Livewire::mount('components.page-filters', ['meta' => $meta, 'filters' => 'id|fechas|documento|estado']);
    $html = $response->html();
    $_instance->logRenderedChild('l845541679-0', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
    <div wire:loading.block class="alert alert-info" role="alert">
        Actualizando Estado de la operacion... <img src="/assets/img/loading.gif" width="35px">
    </div>

    <div class="message-wrapper border-0 bg-white shadow rounded mb-1" style="clear:both; font-size:13px">
        <div class="card-body d-flex align-items-center flex-wrap flex-lg-nowrap py-0">
            <div class="col-1 align-items-center px-0 d-none d-lg-flex center" style="width:35px">#</div>
            <div class="col-4 col-lg-1 ps-0 ps-lg-2 pe-lg-3">Riesgo</div>
            <div class="col-4 col-lg-1 ps-0 ps-lg-2 pe-lg-3">SubRiesgo</div>
            <div class="col-4 col-lg-2 ps-0 ps-lg-3 pe-lg-3" style="width:160px">Inicio / Fin</div>
            <div class="col-4 col-lg-2 ps-0 ps-lg-3 pe-lg-3" style="width:160px">Asegurado</div>
            <div class="col-3 col-lg-1 ps-0 ps-lg-1 pe-lg-1">Aplicacion</div>
            <div class="col-3 col-lg-1 ps-0 ps-lg-1 pe-lg-1">Precio</div>
            <div class="col-3 col-lg-1 ps-0 ps-lg-1 pe-lg-1">Estado</div>
            <div class="col-1 col-lg-1 ps-0 ps-lg-3 pe-lg-3">Compañia</div>
            <div class="col-3 col-lg-1 ps-0 ps-lg-1 pe-lg-1">Creacion</div>
            <div class="col-3 col-lg-1 ps-0 ps-lg-1 pe-lg-1">Opciones</div>
        </div>
    </div>
    <?php if(!$seguros || $seguros == null): ?>
        <div class="alert alert-success" role="alert">
            <i class="fa fa-superpowers" aria-hidden="true"></i>Sin resultados para la busqueda generada.
        </div>
    <?php else: ?>
        <?php $__currentLoopData = $seguros; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seguro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="message-wrapper border-0 bg-white shadow rounded mb-1" style="clear:both; font-size:13px; color:#4e4e4e">
                <div class="card hover-state border-bottom rounded-0 rounded-top py-3">
                    <div class="card-body d-flex align-items-center flex-wrap flex-lg-nowrap py-0">
                        <div class="col-6 col-lg-1 align-items-center px-0 d-lg-flex" style="width:35px">
                            <?php echo e($seguro['id']); ?>

                        </div>
                        <div class="col-6 col-lg-1 align-items-center px-0 d-lg-flex">
                            <?php echo e($seguro['insurance']['risk_type']['name']); ?>

                        </div>
                        <div class="col-12 col-lg-1 ps-0 ps-lg-2 pe-lg-2">
                            <?php echo e($seguro['risk']['risk_sub_type']['name']); ?>

                        </div>

                        <div class="col-6 col-lg-1 ps-0 ps-lg-3 pe-lg-3" style="width:160px">
                            <a href="/seguro/<?php echo e($seguro['id']); ?>"
                                class="fw-normal text-gray-600-900 truncate-text"><?php echo e($this->getFecha($seguro['validity_start'],1)); ?> <br>
                                <?php echo e($this->getFecha($seguro['validity_end'],1)); ?> </a>
                        </div>
                        <div class="col-3 col-lg-2 ps-0 ps-lg-1 pe-lg-1" style="width: 160px">
                            Asegurado: <?php echo e($seguro['insured_entity']['name_nice']); ?> (<?php echo e($seguro['insured_entity']['document']); ?>)<br>
                            Por:<?php echo e($seguro['creator_entity']['name_nice']); ?>

                        </div>
                        <div class="col-3 col-lg-1 ps-0 ps-lg-1 pe-lg-1 activo">
                            <?php echo e($seguro['insurance']['application']['name'] ?? 'noapplicationinfo'); ?>

                        </div>
                        <div class="col-3 col-lg-1 ps-0 ps-lg-1 pe-lg-1" style="width: 90px;">
                            <?php echo e($seguro['quote']['sub_total_price_nice']); ?>

                        </div>

                        <div class="col-3 col-lg-1 ps-0 ps-lg-1 pe-lg-2" style="text-align:center;">
                            <span class="btn btn-info" style="font-size:12px; padding:5px 8px; text-transform:lowercase"><?php echo e($seguro['status']); ?></span>
                        </div>

                        <div class="col-6 col-lg-1 ps-0 ps-lg-3 pe-lg-3" style="text-align:center">
                            <img src="<?php echo e($seguro['company']['logo_filename']); ?>"
                                class="avatar-sm rounded-circle me-3" alt="<?php echo e($seguro['company']['name']); ?>">
                          </div>


                        <div class="col-6 col-lg-1 ps-0 ps-lg-1 pe-lg-2">
                            <?php echo e($this->getFecha($seguro['created_at'])); ?>

                        </div>

                        <div class="col-3 col-lg-1 d-flex align-items-center justify-content-end px-0 order-lg-2">
                            <div class="dropdown ms-3">
                                <button type="button" class="btn btn-sm fs-6 px-1 py-0 dropdown-toggle"
                                    id="dropdownMenuLink" data-bs-toggle="dropdown" aria-expanded="false">
                                    <svg class="icon icon-xs" fill="currentColor" viewBox="0 0 20 20"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M6 10a2 2 0 11-4 0 2 2 0 014 0zM12 10a2 2 0 11-4 0 2 2 0 014 0zM16 12a2 2 0 100-4 2 2 0 000 4z">
                                        </path>
                                    </svg>
                                </button>
                                <div class="dropdown-menu dashboard-dropdown dropdown-menu-start mt-2 py-1">
                                    <a class="dropdown-item d-flex align-items-center"
                                        href="/seguros/<?php echo e($seguro['id']); ?>">
                                        <svg class="dropdown-icon text-gray-400 me-2" fill="currentColor"
                                            viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd"
                                                d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z"
                                                clip-rule="evenodd"></path>
                                        </svg> Ver detalle
                                    </a>
                                    <a class="dropdown-item d-flex align-items-center" href="<?php echo e($apiUrl); ?>/common/insurance-risks/<?php echo e($seguro['id']); ?>/certificate">
                                        <svg class="dropdown-icon text-gray-400 me-2" fill="currentColor"
                                            viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd"
                                                d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z"
                                                clip-rule="evenodd"></path>
                                        </svg> Descargar certificado
                                    </a>






                                    <div role="separator" class="dropdown-divider my-1"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
</div>
<?php /**PATH C:\home\mecubro-admin.local\resources\views/livewire/seguros/seguros.blade.php ENDPATH**/ ?>