<div>
    <title>MeCubro | Usuarios</title>
    <?php if(session()->has('message-danger')): ?>
        <div class="alert alert-danger">
            <?php echo e(session('message-danger')); ?>

        </div>
    <?php endif; ?>
    <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('components.page-filters', ['meta' => $meta, 'filters' => 'id, name, email', 'botones' => ['Añadir Usuario'], 'links' => ['openModal']])->html();
} elseif ($_instance->childHasBeenRendered('l2644335785-0')) {
    $componentId = $_instance->getRenderedChildComponentId('l2644335785-0');
    $componentTag = $_instance->getRenderedChildComponentTagName('l2644335785-0');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('l2644335785-0');
} else {
    $response = \Livewire\Livewire::mount('components.page-filters', ['meta' => $meta, 'filters' => 'id, name, email', 'botones' => ['Añadir Usuario'], 'links' => ['openModal']]);
    $html = $response->html();
    $_instance->logRenderedChild('l2644335785-0', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
    <div class="clear"></div>

    <div wire:loading.delay class="alert alert-info" role="alert">
        Actualizando Estado de la operacion... <img src="/assets/img/loading.gif" width="35px">
    </div>
    <?php if(session()->has('message-success')): ?>
        <div class="alert alert-success">
            <?php echo e(session('message-success')); ?>

        </div>
    <?php endif; ?>
    <div class="message-wrapper border-0 bg-white shadow rounded mb-1" style="clear:both">
        <div class="card-body d-flex align-items-center flex-wrap flex-lg-nowrap py-0">
            <div class="col-1 align-items-center px-0 d-none d-lg-flex center">ID</div>
            <div class="col-1 col-lg-2 ps-0 ps-lg-3 pe-lg-3">Usuario</div>
            <div class="col-3 col-lg-1 ps-0 ps-lg-1 pe-lg-1 center">doc/Tel</div>
            <div class="col-3 col-lg-2 ps-0 ps-lg-3 pe-lg-2 center">Email</div>
            <div class="col-2 col-lg-1 ps-0 ps-lg-1 pe-lg-2 center"></div>
            <div class="col-4 col-lg-1">Pais</div>
            <div class="col-4 col-lg-1"></div>
            <div class="col-4 col-lg-1"></div>
            <div class="col-4 col-lg-1 ps-0 ps-lg-3 pe-lg-3 center"></div>
        </div>
    </div>
    <?php if(!$usuarios || $usuarios == null): ?>
        <div class="alert alert-success" role="alert">
            <i class="fa fa-superpowers" aria-hidden="true"></i>Sin resultados para la busqueda generada.
        </div>
    <?php else: ?>
        <?php $__currentLoopData = $usuarios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $usuario): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="message-wrapper border-0 bg-white shadow rounded mb-1">
                <div class="card hover-state border-bottom rounded-0 rounded-top py-3">
                    <div class="card-body d-flex align-items-center flex-wrap flex-lg-nowrap py-0">
                        <div class="col-1 col-lg-1 align-items-center px-0 d-lg-flex">
                            <?php echo e($usuario['id']); ?>

                        </div>
                        <div class="col-4 col-lg-2 ps-0 ps-lg-2 pe-lg-2">
                                <img src="<?php echo e($usuario['avatar']); ?>" class="avatar-sm rounded-circle me-3"
                                alt="<?php echo e($usuario['name']); ?>">
                                <?php echo e($usuario['name']); ?>

                        </div>
                        <div class="col-5 col-lg-1 ps-0 ps-lg-4 pe-lg-3">
                            <a href="/usuarios/<?php echo e($usuario['id']); ?>" class="fw-normal text-gray-600-900 truncate-text"><?php echo e($usuario['entity']['document_nice'] ?? ''); ?> <br> Te: <?php echo e($usuario['phone']); ?> </a>
                        </div>
                        <div class="col-5 col-lg-3">
                            <a href="/usuarios/<?php echo e($usuario['id']); ?>" class="fw-normal text-gray-600-900 truncate-text"><span class="fw-bold ps-lg-5"><?php echo e($usuario['email']); ?> </span></a>
                        </div>
                        <div class="col-6 col-lg-1">
                            <span class=""><?php echo e($usuario['country']['name']); ?> </span>
                        </div>
                        <div class="col-6 col-lg-1">
                            <span class="btn btn-success users-status"><?php echo e($usuario['active'] ? "Active" : "Inactivo"); ?> </span>
                        </div>
                        <div class="col-6 col-lg-1">
                            <span><?php echo e($this->getFecha($usuario['created_at'] )); ?></span>
                        </div>
                        <div class="col-5 col-lg-1">
                            <a class="btn btn-outline-gray-600 d-inline-flex align-items-center"
                                href="/usuarios/<?php echo e($usuario['id']); ?>">
                                <span class="sidebar-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" stroke="currentColor"
                                        stroke-width="" viewBox="" aria-hidden="true">
                                        <path stroke-linecap="round" stroke-linejoin="round"
                                            d="M17.982 18.725A7.488 7.488 0 0012 15.75a7.488 7.488 0 00-5.982 2.975m11.963 0a9 9 0 10-11.963 0m11.963 0A8.966 8.966 0 0112 21a8.966 8.966 0 01-5.982-2.275M15 9.75a3 3 0 11-6 0 3 3 0 016 0z" />
                                    </svg>
                                </span>
                                &nbsp; Detalle</a>
                        </div>

                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
    <!-- Emergente añadir usuario -->
    <?php if($modal_open == true): ?>
        <div class="modal fade show" id="modalNotification" tabindex="-1" role="dialog"
            aria-labelledby="modalTitleNotify" aria-modal="true" style="display: block;">
            <div class="modal-dialog modal-dialog-centered" role="document"
                style="width:65%!important; max-width:750px">
                <div class="modal-content">
                    <div class="modal-header">
                        <p class="modal-title" id="modalTitleNotify">Añadir usuario a MeCubro</p>
                        <button type="button" wire:click="cerrarModal()" class="btn-close"></button>
                    </div>
                    <div class="modal-body">
                        <form wire:submit.prevent="crearUsuario">
                            <div class="col-12 col-xl-12">
                                <div class="card card-body border-0 shadow mb-4">
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <div><label for="first_name">Nombre</label> <input class="form-control"
                                                    id="first_name" type="text" placeholder="Ingrese nombre"
                                                    required="" wire:model.defer="userInfo.user.first_name"></div>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <div><label for="last_name">Apellido</label> <input class="form-control"
                                                    id="last_name" type="text" placeholder="Ingrese apellido"
                                                    required="" wire:model.defer="userInfo.user.last_name"></div>
                                        </div>
                                    </div>
                                    <div class="row align-items-center">
                                        <div class="col-md-6 mb-3">
                                            <label for="password">Clave</label>
                                            <div class="input-group"><input type="password" class="form-control"
                                                    placeholder="Password" wire:model.defer="userInfo.user.password"> <span
                                                    class="input-group-text" id="basic-addon3"><svg
                                                        class="icon icon-xs text-gray-600" fill="currentColor"
                                                        viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                                        <path fill-rule="evenodd"
                                                            d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z"
                                                            clip-rule="evenodd"></path>
                                                    </svg></span></div>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label for="gender">Pais</label>
                                            <select class="form-select mb-0" id="gender"
                                                wire:model.defer="userInfo.user.country">
                                                <option selected="selected" value="ar">Argentina</option>
                                                <option value="pe">Peru</option>
                                                <option value="co">Colombia</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <div class="form-group"><label for="email">Email</label> <input
                                                    class="form-control" id="email" type="email"
                                                    placeholder="name@company.com" required=""
                                                    wire:model.defer="userInfo.user.email"></div>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <div class="form-group"><label for="phone">Telefono</label> <input
                                                    class="form-control" id="phone" type="number"
                                                    placeholder="Ingrese telefono" required=""
                                                    wire:model.defer="userInfo.user.phone"></div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-sm-4 mb-3">
                                            <div class="form-group"><label for="city">Documento</label> <input
                                                    class="form-control" id="documento" type="text"
                                                    placeholder="documento" required=""
                                                    wire:model.defer="userInfo.user.document"></div>
                                        </div>

                                    </div>




                                    <div class="mt-3"><button class="btn btn-gray-800 mt-2 animate-up-2"
                                            type="submit">Añadir usuario a Mecubro.com</button></div>
                                </div>
                            </div>
                        </form>
                        <?php if(session()->has('message-danger')): ?>
                            <div class="alert alert-danger">
                                <?php echo e(session('message-danger')); ?>

                            </div>
                        <?php endif; ?>
                        <div wire:loading.delay class="alert alert-success" role="alert">
                            Actualizando Estado...
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-backdrop fade show"></div>
    <?php endif; ?>
</div>
<?php /**PATH C:\home\mecubro-admin.local\resources\views/livewire/usuarios/usuarios.blade.php ENDPATH**/ ?>